/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.datagen.providers;

import java.util.Objects;
import mod.traister101.sns.common.items.SNSItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BuiltInItemModels
extends ItemModelProvider {
    public static final ResourceLocation SMALL_SACK = new ResourceLocation("sns", "item/held/small_sack");
    public static final ResourceLocation LARGE_SACK = new ResourceLocation("sns", "item/held/large_sack");

    public BuiltInItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "sns", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)SNSItems.UNFINISHED_LEATHER_SACK.get());
        this.basicItem((Item)SNSItems.REINFORCED_FIBER.get());
        this.basicItem((Item)SNSItems.REINFORCED_FABRIC.get());
        this.basicItem((Item)SNSItems.PACK_FRAME.get());
        this.iconWithHeldModel((Item)SNSItems.STRAW_BASKET.get());
        this.iconWithHeldModel((Item)SNSItems.LEATHER_SACK.get(), (ModelFile)((ItemModelBuilder)this.withExistingParent("item/held/leather_sack", SMALL_SACK)).texture("sack", this.modLoc("item/held/leather_sack")));
        this.iconWithHeldModel((Item)SNSItems.BURLAP_SACK.get(), (ModelFile)((ItemModelBuilder)this.withExistingParent("item/held/burlap_sack", SMALL_SACK)).texture("sack", this.modLoc("item/held/burlap_sack")));
        this.iconWithHeldModel((Item)SNSItems.ORE_SACK.get(), (ModelFile)((ItemModelBuilder)this.withExistingParent("item/held/ore_sack", LARGE_SACK)).texture("sack", this.modLoc("item/held/ore_sack")));
        this.iconWithHeldModel((Item)SNSItems.SEED_POUCH.get(), (ModelFile)((ItemModelBuilder)this.withExistingParent("item/held/seed_pouch", SMALL_SACK)).texture("sack", this.modLoc("item/held/seed_pouch")));
        this.iconWithHeldModel((Item)SNSItems.FRAME_PACK.get());
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> iconWithHeldModel(Item item) {
        return this.iconWithHeldModel(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> iconWithHeldModel(ResourceLocation item) {
        return this.iconWithHeldModel(item, (ModelFile)this.getExistingFile(item.m_246208_("item/held/")));
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> iconWithHeldModel(Item item, ModelFile heldModel) {
        return this.iconWithHeldModel(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)), heldModel);
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> iconWithHeldModel(ResourceLocation item, ModelFile heldModel) {
        return this.iconWithHeldModel(item, heldModel, (ModelFile)this.icon(item));
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> iconWithHeldModel(ResourceLocation item, ModelFile heldModel, ModelFile iconModel) {
        return this.getTransformedItemModelBuilder(item).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent(heldModel))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent(iconModel))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent(iconModel))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent(iconModel)));
    }

    private ItemModelBuilder icon(Item item) {
        return this.icon(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
    }

    private ItemModelBuilder icon(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.m_246208_("icon/").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", item.m_246208_("item/icon/"));
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> getTransformedItemModelBuilder(Item item) {
        return this.getTransformedItemModelBuilder(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
    }

    private SeparateTransformsModelBuilder<ItemModelBuilder> getTransformedItemModelBuilder(ResourceLocation key) {
        return (SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(key.toString())).parent((ModelFile)this.getExistingFile(new ResourceLocation("forge", "item/default")))).customLoader(SeparateTransformsModelBuilder::begin);
    }
}

